/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public abstract class BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockEntityType<?> type;
    @Nullable
    protected Level level;
    protected final BlockPos worldPosition;
    protected boolean remove;
    private BlockState blockState;
    private DataComponentMap components = DataComponentMap.EMPTY;

    public BlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        this.type = p_155228_;
        this.worldPosition = p_155229_.immutable();
        this.blockState = p_155230_;
    }

    public static BlockPos getPosFromTag(CompoundTag p_187473_) {
        return new BlockPos(p_187473_.getInt("x"), p_187473_.getInt("y"), p_187473_.getInt("z"));
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level p_155231_) {
        this.level = p_155231_;
    }

    public boolean hasLevel() {
        return this.level != null;
    }

    protected void loadAdditional(CompoundTag p_338466_, HolderLookup.Provider p_338445_) {
    }

    public final void loadWithComponents(CompoundTag p_338356_, HolderLookup.Provider p_338558_) {
        this.loadAdditional(p_338356_, p_338558_);
        ComponentHelper.COMPONENTS_CODEC.parse(p_338558_.createSerializationContext(NbtOps.INSTANCE), (Object)p_338356_).resultOrPartial(p_337987_ -> LOGGER.warn("Failed to load components: {}", p_337987_)).ifPresent(p_337995_ -> {
            this.components = p_337995_;
        });
    }

    public final void loadCustomOnly(CompoundTag p_338387_, HolderLookup.Provider p_338713_) {
        this.loadAdditional(p_338387_, p_338713_);
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider p_323635_) {
    }

    public final CompoundTag saveWithFullMetadata(HolderLookup.Provider p_323767_) {
        CompoundTag $$1 = this.saveWithoutMetadata(p_323767_);
        this.saveMetadata($$1);
        return $$1;
    }

    public final CompoundTag saveWithId(HolderLookup.Provider p_324357_) {
        CompoundTag $$1 = this.saveWithoutMetadata(p_324357_);
        this.saveId($$1);
        return $$1;
    }

    public final CompoundTag saveWithoutMetadata(HolderLookup.Provider p_324030_) {
        CompoundTag $$1 = new CompoundTag();
        this.saveAdditional($$1, p_324030_);
        ComponentHelper.COMPONENTS_CODEC.encodeStart(p_324030_.createSerializationContext(NbtOps.INSTANCE), (Object)this.components).resultOrPartial(p_337988_ -> LOGGER.warn("Failed to save components: {}", p_337988_)).ifPresent(p_337994_ -> $$1.merge((CompoundTag)p_337994_));
        return $$1;
    }

    public final CompoundTag saveCustomOnly(HolderLookup.Provider p_338656_) {
        CompoundTag $$1 = new CompoundTag();
        this.saveAdditional($$1, p_338656_);
        return $$1;
    }

    public final CompoundTag saveCustomAndMetadata(HolderLookup.Provider p_339688_) {
        CompoundTag $$1 = this.saveCustomOnly(p_339688_);
        this.saveMetadata($$1);
        return $$1;
    }

    private void saveId(CompoundTag p_187475_) {
        ResourceLocation $$1 = BlockEntityType.getKey(this.getType());
        if ($$1 == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        p_187475_.putString("id", $$1.toString());
    }

    public static void addEntityType(CompoundTag p_187469_, BlockEntityType<?> p_187470_) {
        p_187469_.putString("id", BlockEntityType.getKey(p_187470_).toString());
    }

    public void saveToItem(ItemStack p_187477_, HolderLookup.Provider p_323484_) {
        CompoundTag $$2 = this.saveCustomOnly(p_323484_);
        this.removeComponentsFromTag($$2);
        BlockItem.setBlockEntityData(p_187477_, this.getType(), $$2);
        p_187477_.applyComponents(this.collectComponents());
    }

    private void saveMetadata(CompoundTag p_187479_) {
        this.saveId(p_187479_);
        p_187479_.putInt("x", this.worldPosition.getX());
        p_187479_.putInt("y", this.worldPosition.getY());
        p_187479_.putInt("z", this.worldPosition.getZ());
    }

    @Nullable
    public static BlockEntity loadStatic(BlockPos p_155242_, BlockState p_155243_, CompoundTag p_155244_, HolderLookup.Provider p_323542_) {
        String $$4 = p_155244_.getString("id");
        ResourceLocation $$5 = ResourceLocation.tryParse($$4);
        if ($$5 == null) {
            LOGGER.error("Block entity has invalid type: {}", (Object)$$4);
            return null;
        }
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getOptional($$5).map(p_155240_ -> {
            try {
                return p_155240_.create(p_155242_, p_155243_);
            }
            catch (Throwable $$4) {
                LOGGER.error("Failed to create block entity {}", (Object)$$4, (Object)$$4);
                return null;
            }
        }).map(p_337992_ -> {
            try {
                p_337992_.loadWithComponents(p_155244_, p_323542_);
                return p_337992_;
            }
            catch (Throwable $$4) {
                LOGGER.error("Failed to load data for block entity {}", (Object)$$4, (Object)$$4);
                return null;
            }
        }).orElseGet(() -> {
            LOGGER.warn("Skipping BlockEntity with id {}", (Object)$$4);
            return null;
        });
    }

    public void setChanged() {
        if (this.level != null) {
            BlockEntity.setChanged(this.level, this.worldPosition, this.blockState);
        }
    }

    protected static void setChanged(Level p_155233_, BlockPos p_155234_, BlockState p_155235_) {
        p_155233_.blockEntityChanged(p_155234_);
        if (!p_155235_.isAir()) {
            p_155233_.updateNeighbourForOutputSignal(p_155234_, p_155235_.getBlock());
        }
    }

    public BlockPos getBlockPos() {
        return this.worldPosition;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return new CompoundTag();
    }

    public boolean isRemoved() {
        return this.remove;
    }

    public void setRemoved() {
        this.remove = true;
    }

    public void clearRemoved() {
        this.remove = false;
    }

    public boolean triggerEvent(int p_58889_, int p_58890_) {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory p_58887_) {
        p_58887_.setDetail("Name", () -> String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.getType())) + " // " + this.getClass().getCanonicalName());
        if (this.level == null) {
            return;
        }
        CrashReportCategory.populateBlockDetails(p_58887_, this.level, this.worldPosition, this.getBlockState());
        CrashReportCategory.populateBlockDetails(p_58887_, this.level, this.worldPosition, this.level.getBlockState(this.worldPosition));
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public BlockEntityType<?> getType() {
        return this.type;
    }

    @Deprecated
    public void setBlockState(BlockState p_155251_) {
        this.blockState = p_155251_;
    }

    protected void applyImplicitComponents(DataComponentInput p_338718_) {
    }

    public final void applyComponentsFromItemStack(ItemStack p_338428_) {
        this.applyComponents(p_338428_.getPrototype(), p_338428_.getComponentsPatch());
    }

    public final void applyComponents(DataComponentMap p_330364_, DataComponentPatch p_338381_) {
        final HashSet<DataComponentType<CustomData>> $$2 = new HashSet<DataComponentType<CustomData>>();
        $$2.add(DataComponents.BLOCK_ENTITY_DATA);
        final PatchedDataComponentMap $$3 = PatchedDataComponentMap.fromPatch(p_330364_, p_338381_);
        this.applyImplicitComponents(new DataComponentInput(){

            @Override
            @Nullable
            public <T> T get(DataComponentType<T> p_338266_) {
                $$2.add(p_338266_);
                return $$3.get(p_338266_);
            }

            @Override
            public <T> T getOrDefault(DataComponentType<? extends T> p_338358_, T p_338352_) {
                $$2.add(p_338358_);
                return $$3.getOrDefault(p_338358_, p_338352_);
            }
        });
        DataComponentPatch $$4 = p_338381_.forget($$2::contains);
        this.components = $$4.split().added();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338210_) {
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag p_332032_) {
    }

    public final DataComponentMap collectComponents() {
        DataComponentMap.Builder $$0 = DataComponentMap.builder();
        $$0.addAll(this.components);
        this.collectImplicitComponents($$0);
        return $$0.build();
    }

    public DataComponentMap components() {
        return this.components;
    }

    public void setComponents(DataComponentMap p_338529_) {
        this.components = p_338529_;
    }

    @Nullable
    public static Component parseCustomNameSafe(String p_342033_, HolderLookup.Provider p_342030_) {
        try {
            return Component.Serializer.fromJson(p_342033_, p_342030_);
        }
        catch (Exception $$2) {
            LOGGER.warn("Failed to parse custom name from string '{}', discarding", (Object)p_342033_, (Object)$$2);
            return null;
        }
    }

    static class ComponentHelper {
        public static final Codec<DataComponentMap> COMPONENTS_CODEC = DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).codec();

        private ComponentHelper() {
        }
    }

    protected static interface DataComponentInput {
        @Nullable
        public <T> T get(DataComponentType<T> var1);

        public <T> T getOrDefault(DataComponentType<? extends T> var1, T var2);
    }
}

