/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] NO_ARGS = new Object[0];
    private static final Codec<Object> PRIMITIVE_ARG_CODEC = ExtraCodecs.JAVA.validate(TranslatableContents::filterAllowedArguments);
    private static final Codec<Object> ARG_CODEC = Codec.either(PRIMITIVE_ARG_CODEC, ComponentSerialization.CODEC).xmap(p_304564_ -> p_304564_.map(p_304446_ -> p_304446_, p_304596_ -> Objects.requireNonNullElse(p_304596_.tryCollapseToString(), p_304596_)), p_304615_ -> {
        Either either;
        if (p_304615_ instanceof Component) {
            Component $$1 = (Component)p_304615_;
            either = Either.right((Object)$$1);
        } else {
            either = Either.left((Object)p_304615_);
        }
        return either;
    });
    public static final MapCodec<TranslatableContents> CODEC = RecordCodecBuilder.mapCodec(p_337512_ -> p_337512_.group((App)Codec.STRING.fieldOf("translate").forGetter(p_304759_ -> p_304759_.key), (App)Codec.STRING.lenientOptionalFieldOf("fallback").forGetter(p_304865_ -> Optional.ofNullable(p_304865_.fallback)), (App)ARG_CODEC.listOf().optionalFieldOf("with").forGetter(p_304814_ -> TranslatableContents.adjustArgs(p_304814_.args))).apply((Applicative)p_337512_, TranslatableContents::create));
    public static final ComponentContents.Type<TranslatableContents> TYPE = new ComponentContents.Type<TranslatableContents>(CODEC, "translatable");
    private static final FormattedText TEXT_PERCENT = FormattedText.of("%");
    private static final FormattedText TEXT_NULL = FormattedText.of("null");
    private final String key;
    @Nullable
    private final String fallback;
    private final Object[] args;
    @Nullable
    private Language decomposedWith;
    private List<FormattedText> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private static DataResult<Object> filterAllowedArguments(@Nullable Object p_304727_) {
        if (!TranslatableContents.isAllowedPrimitiveArgument(p_304727_)) {
            return DataResult.error(() -> "This value needs to be parsed as component");
        }
        return DataResult.success((Object)p_304727_);
    }

    public static boolean isAllowedPrimitiveArgument(@Nullable Object p_304690_) {
        return p_304690_ instanceof Number || p_304690_ instanceof Boolean || p_304690_ instanceof String;
    }

    private static Optional<List<Object>> adjustArgs(Object[] p_304743_) {
        return p_304743_.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(p_304743_));
    }

    private static Object[] adjustArgs(Optional<List<Object>> p_304744_) {
        return p_304744_.map(p_304855_ -> p_304855_.isEmpty() ? NO_ARGS : p_304855_.toArray()).orElse(NO_ARGS);
    }

    private static TranslatableContents create(String p_304502_, Optional<String> p_304440_, Optional<List<Object>> p_304710_) {
        return new TranslatableContents(p_304502_, p_304440_.orElse(null), TranslatableContents.adjustArgs(p_304710_));
    }

    public TranslatableContents(String p_265775_, @Nullable String p_265204_, Object[] p_265752_) {
        this.key = p_265775_;
        this.fallback = p_265204_;
        this.args = p_265752_;
    }

    @Override
    public ComponentContents.Type<?> type() {
        return TYPE;
    }

    private void decompose() {
        Language $$0 = Language.getInstance();
        if ($$0 == this.decomposedWith) {
            return;
        }
        this.decomposedWith = $$0;
        String $$1 = this.fallback != null ? $$0.getOrDefault(this.key, this.fallback) : $$0.getOrDefault(this.key);
        try {
            ImmutableList.Builder $$2 = ImmutableList.builder();
            this.decomposeTemplate($$1, arg_0 -> ((ImmutableList.Builder)$$2).add(arg_0));
            this.decomposedParts = $$2.build();
        }
        catch (TranslatableFormatException $$3) {
            this.decomposedParts = ImmutableList.of((Object)FormattedText.of($$1));
        }
    }

    private void decomposeTemplate(String p_237516_, Consumer<FormattedText> p_237517_) {
        Matcher $$2 = FORMAT_PATTERN.matcher(p_237516_);
        try {
            int $$3 = 0;
            int $$4 = 0;
            while ($$2.find($$4)) {
                int $$5 = $$2.start();
                int $$6 = $$2.end();
                if ($$5 > $$4) {
                    String $$7 = p_237516_.substring($$4, $$5);
                    if ($$7.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    p_237517_.accept(FormattedText.of($$7));
                }
                String $$8 = $$2.group(2);
                String $$9 = p_237516_.substring($$5, $$6);
                if ("%".equals($$8) && "%%".equals($$9)) {
                    p_237517_.accept(TEXT_PERCENT);
                } else if ("s".equals($$8)) {
                    String $$10 = $$2.group(1);
                    int $$11 = $$10 != null ? Integer.parseInt($$10) - 1 : $$3++;
                    p_237517_.accept(this.getArgument($$11));
                } else {
                    throw new TranslatableFormatException(this, "Unsupported format: '" + $$9 + "'");
                }
                $$4 = $$6;
            }
            if ($$4 < p_237516_.length()) {
                String $$12 = p_237516_.substring($$4);
                if ($$12.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                p_237517_.accept(FormattedText.of($$12));
            }
        }
        catch (IllegalArgumentException $$13) {
            throw new TranslatableFormatException(this, (Throwable)$$13);
        }
    }

    private FormattedText getArgument(int p_237510_) {
        if (p_237510_ < 0 || p_237510_ >= this.args.length) {
            throw new TranslatableFormatException(this, p_237510_);
        }
        Object $$1 = this.args[p_237510_];
        if ($$1 instanceof Component) {
            Component $$2 = (Component)$$1;
            return $$2;
        }
        return $$1 == null ? TEXT_NULL : FormattedText.of($$1.toString());
    }

    @Override
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> p_237521_, Style p_237522_) {
        this.decompose();
        for (FormattedText $$2 : this.decomposedParts) {
            Optional<T> $$3 = $$2.visit(p_237521_, p_237522_);
            if (!$$3.isPresent()) continue;
            return $$3;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> p_237519_) {
        this.decompose();
        for (FormattedText $$1 : this.decomposedParts) {
            Optional<T> $$2 = $$1.visit(p_237519_);
            if (!$$2.isPresent()) continue;
            return $$2;
        }
        return Optional.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack p_237512_, @Nullable Entity p_237513_, int p_237514_) throws CommandSyntaxException {
        Object[] $$3 = new Object[this.args.length];
        for (int $$4 = 0; $$4 < $$3.length; ++$$4) {
            Object $$5 = this.args[$$4];
            if ($$5 instanceof Component) {
                Component $$6 = (Component)$$5;
                $$3[$$4] = ComponentUtils.updateForEntity(p_237512_, $$6, p_237513_, p_237514_);
                continue;
            }
            $$3[$$4] = $$5;
        }
        return MutableComponent.create(new TranslatableContents(this.key, this.fallback, $$3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_237526_) {
        if (this == p_237526_) {
            return true;
        }
        if (!(p_237526_ instanceof TranslatableContents)) return false;
        TranslatableContents $$1 = (TranslatableContents)p_237526_;
        if (!Objects.equals(this.key, $$1.key)) return false;
        if (!Objects.equals(this.fallback, $$1.fallback)) return false;
        if (!Arrays.equals(this.args, $$1.args)) return false;
        return true;
    }

    public int hashCode() {
        int $$0 = Objects.hashCode(this.key);
        $$0 = 31 * $$0 + Objects.hashCode(this.fallback);
        $$0 = 31 * $$0 + Arrays.hashCode(this.args);
        return $$0;
    }

    public String toString() {
        return "translation{key='" + this.key + "'" + (String)(this.fallback != null ? ", fallback='" + this.fallback + "'" : "") + ", args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getFallback() {
        return this.fallback;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

