/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.CommonHooks;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> p_255625_) {
        return new EmptyTagLookup<T>(p_255625_){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255765_) {
                return p_255625_.get(p_255765_);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> lookupFromMap(final ResourceKey<? extends Registry<? extends T>> p_312781_, final Lifecycle p_312783_, HolderOwner<T> p_326787_, final Map<ResourceKey<T>, Holder.Reference<T>> p_312180_) {
        return new EmptyTagRegistryLookup<T>(p_326787_){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return p_312781_;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return p_312783_;
            }

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_312659_) {
                return Optional.ofNullable((Holder.Reference)p_312180_.get(p_312659_));
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return p_312180_.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256446_, Lifecycle p_256394_, RegistryBootstrap<T> p_256638_) {
        this.entries.add(new RegistryStub<T>(p_256446_, p_256394_, p_256638_));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> p_256261_, RegistryBootstrap<T> p_256010_) {
        return this.add(p_256261_, Lifecycle.stable(), p_256010_);
    }

    public List<? extends ResourceKey<? extends Registry<?>>> getEntryKeys() {
        return this.entries.stream().map(RegistryStub::key).toList();
    }

    private BuildState createState(RegistryAccess p_256400_) {
        BuildState registrysetbuilder$buildstate = BuildState.create(p_256400_, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(p_255629_ -> p_255629_.apply(registrysetbuilder$buildstate));
        return registrysetbuilder$buildstate;
    }

    private static HolderLookup.Provider buildProviderWithContext(UniversalOwner p_326837_, RegistryAccess p_312694_, Stream<HolderLookup.RegistryLookup<?>> p_312024_) {
        record Entry<T>(HolderLookup.RegistryLookup<T> lookup, RegistryOps.RegistryInfo<T> opsInfo) {
            public static <T> Entry<T> createForContextRegistry(HolderLookup.RegistryLookup<T> p_326874_) {
                return new Entry<T>(new EmptyTagLookupWrapper<T>(p_326874_, p_326874_), RegistryOps.RegistryInfo.fromRegistryLookup(p_326874_));
            }

            public static <T> Entry<T> createForNewRegistry(UniversalOwner p_326836_, HolderLookup.RegistryLookup<T> p_326940_) {
                return new Entry(new EmptyTagLookupWrapper(p_326836_.cast(), p_326940_), new RegistryOps.RegistryInfo(p_326836_.cast(), p_326940_, p_326940_.registryLifecycle()));
            }
        }
        final HashMap map = new HashMap();
        p_312694_.registries().forEach(p_326730_ -> map.put(p_326730_.key(), Entry.createForContextRegistry(p_326730_.value().asLookup())));
        p_312024_.forEach(p_326724_ -> map.put(p_326724_.key(), Entry.createForNewRegistry(p_326837_, p_326724_)));
        return new HolderLookup.Provider(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return map.keySet().stream();
            }

            <T> Optional<Entry<T>> getEntry(ResourceKey<? extends Registry<? extends T>> p_326910_) {
                return Optional.ofNullable((Entry)map.get(p_326910_));
            }

            @Override
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_326942_) {
                return this.getEntry(p_326942_).map(Entry::lookup);
            }

            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> p_326947_) {
                return RegistryOps.create(p_326947_, new RegistryOps.RegistryInfoLookup(){

                    @Override
                    public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_326905_) {
                        return this.getEntry(p_326905_).map(Entry::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.Provider build(RegistryAccess p_256112_) {
        BuildState registrysetbuilder$buildstate = this.createState(p_256112_);
        Stream<HolderLookup.RegistryLookup<?>> stream = this.entries.stream().map(p_326726_ -> p_326726_.collectRegisteredValues(registrysetbuilder$buildstate).buildAsLookup(registrysetbuilder$buildstate.owner));
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.buildProviderWithContext(registrysetbuilder$buildstate.owner, p_256112_, stream);
        registrysetbuilder$buildstate.reportNotCollectedHolders();
        registrysetbuilder$buildstate.reportUnclaimedRegisteredValues();
        registrysetbuilder$buildstate.throwOnError();
        return holderlookup$provider;
    }

    private HolderLookup.Provider createLazyFullPatchedRegistries(RegistryAccess p_312301_, HolderLookup.Provider p_311942_, Cloner.Factory p_312464_, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> p_312890_, HolderLookup.Provider p_311825_) {
        UniversalOwner registrysetbuilder$universalowner = new UniversalOwner();
        MutableObject mutableobject = new MutableObject();
        List list = p_312890_.keySet().stream().map(p_311471_ -> this.createLazyFullPatchedRegistries(registrysetbuilder$universalowner, p_312464_, (ResourceKey)p_311471_, p_311825_, p_311942_, (MutableObject<HolderLookup.Provider>)mutableobject)).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.buildProviderWithContext(registrysetbuilder$universalowner, p_312301_, list.stream());
        mutableobject.setValue((Object)holderlookup$provider);
        return holderlookup$provider;
    }

    private <T> HolderLookup.RegistryLookup<T> createLazyFullPatchedRegistries(HolderOwner<T> p_312323_, Cloner.Factory p_311780_, ResourceKey<? extends Registry<? extends T>> p_311836_, HolderLookup.Provider p_312115_, HolderLookup.Provider p_312725_, MutableObject<HolderLookup.Provider> p_311797_) {
        Lifecycle lifecycle;
        Cloner cloner = p_311780_.cloner(p_311836_);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(p_311836_.location()));
        }
        HashMap map = new HashMap();
        HolderLookup.RegistryLookup registrylookup = p_312115_.lookupOrThrow(p_311836_);
        registrylookup.listElements().forEach(p_311483_ -> {
            ResourceKey resourcekey = p_311483_.key();
            LazyHolder lazyholder = new LazyHolder(p_312323_, resourcekey);
            lazyholder.supplier = () -> cloner.clone(p_311483_.value(), p_312115_, (HolderLookup.Provider)p_311797_.getValue());
            map.put(resourcekey, lazyholder);
        });
        Optional lookup = p_312725_.lookup(p_311836_);
        if (lookup.isPresent()) {
            HolderLookup.RegistryLookup registrylookup1 = lookup.get();
            registrylookup1.listElements().forEach(p_311506_ -> {
                ResourceKey resourcekey = p_311506_.key();
                map.computeIfAbsent(resourcekey, p_311494_ -> {
                    LazyHolder lazyholder = new LazyHolder(p_312323_, resourcekey);
                    lazyholder.supplier = () -> cloner.clone(p_311506_.value(), p_312725_, (HolderLookup.Provider)p_311797_.getValue());
                    return lazyholder;
                });
            });
            lifecycle = registrylookup.registryLifecycle().add(registrylookup1.registryLifecycle());
        } else {
            lifecycle = registrylookup.registryLifecycle();
        }
        return RegistrySetBuilder.lookupFromMap(p_311836_, lifecycle, p_312323_, map);
    }

    public PatchedRegistries buildPatch(RegistryAccess p_255676_, HolderLookup.Provider p_255900_, Cloner.Factory p_312173_) {
        BuildState registrysetbuilder$buildstate = this.createState(p_255676_);
        HashMap map = new HashMap();
        this.entries.stream().map(p_311508_ -> p_311508_.collectRegisteredValues(registrysetbuilder$buildstate)).forEach(p_272339_ -> map.put((ResourceKey<Registry<?>>)p_272339_.key, (RegistryContents<?>)p_272339_));
        Set set = p_255676_.listRegistries().collect(Collectors.toUnmodifiableSet());
        p_255900_.listRegistries().filter(p_311485_ -> !set.contains(p_311485_)).forEach(p_311473_ -> map.putIfAbsent((ResourceKey<Registry<?>>)p_311473_, new RegistryContents(p_311473_, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> stream = map.values().stream().map(p_326728_ -> p_326728_.buildAsLookup(registrysetbuilder$buildstate.owner));
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.buildProviderWithContext(registrysetbuilder$buildstate.owner, p_255676_, stream);
        registrysetbuilder$buildstate.reportUnclaimedRegisteredValues();
        registrysetbuilder$buildstate.throwOnError();
        HolderLookup.Provider holderlookup$provider1 = this.createLazyFullPatchedRegistries(p_255676_, p_255900_, p_312173_, map, holderlookup$provider);
        return new PatchedRegistries(holderlookup$provider1, holderlookup$provider);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState p_256272_) {
            this.bootstrap.run(p_256272_.bootstrapContext());
        }

        public RegistryContents<T> collectRegisteredValues(BuildState p_256416_) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = p_256416_.registeredValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourcekey = entry.getKey();
                if (!resourcekey.isFor(this.key)) continue;
                RegisteredValue<?> registeredvalue = entry.getValue();
                Holder.Reference<Object> reference = p_256416_.lookup.holders.remove(resourcekey);
                map.put(resourcekey, new ValueAndHolder(registeredvalue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, map);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstrapContext<T> var1);
    }

    record BuildState(UniversalOwner owner, UniversalLookup lookup, Map<ResourceLocation, HolderGetter<?>> registries, Map<ResourceKey<?>, RegisteredValue<?>> registeredValues, List<RuntimeException> errors) {
        public static BuildState create(RegistryAccess p_255995_, Stream<ResourceKey<? extends Registry<?>>> p_256495_) {
            UniversalOwner registrysetbuilder$universalowner = new UniversalOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup registrysetbuilder$universallookup = new UniversalLookup(registrysetbuilder$universalowner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            p_255995_.registries().forEach(p_258197_ -> builder.put((Object)p_258197_.key().location(), (Object)CommonHooks.wrapRegistryLookup(p_258197_.value().asLookup())));
            p_256495_.forEach(p_256603_ -> builder.put((Object)p_256603_.location(), (Object)registrysetbuilder$universallookup));
            return new BuildState(registrysetbuilder$universalowner, registrysetbuilder$universallookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.Reference<T> register(ResourceKey<T> p_256176_, T p_256422_, Lifecycle p_255924_) {
                    RegisteredValue registeredvalue = registeredValues.put(p_256176_, new RegisteredValue(p_256422_, p_255924_));
                    if (registeredvalue != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(p_256176_) + ", new=" + String.valueOf(p_256422_) + ", old=" + String.valueOf(registeredvalue.value)));
                    }
                    return lookup.getOrCreate(p_256176_);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> p_255961_) {
                    return registries.getOrDefault(p_255961_.location(), lookup);
                }

                @Override
                public <S> Optional<HolderLookup.RegistryLookup<S>> registryLookup(ResourceKey<? extends Registry<? extends S>> registry) {
                    return Optional.ofNullable((HolderLookup.RegistryLookup)registries.get(registry.location()));
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((p_339338_, p_339339_) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(p_339339_.value) + " for key " + String.valueOf(p_339338_))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> resourcekey : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourcekey)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException illegalstateexception = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeexception : this.errors) {
                    illegalstateexception.addSuppressed(runtimeexception);
                }
                throw illegalstateexception;
            }
        }
    }

    static class UniversalOwner
    implements HolderOwner<Object> {
        UniversalOwner() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider full, HolderLookup.Provider patches) {
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> key, Lifecycle lifecycle, Map<ResourceKey<T>, ValueAndHolder<T>> values) {
        public HolderLookup.RegistryLookup<T> buildAsLookup(UniversalOwner p_326796_) {
            Map map = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, p_311927_ -> {
                ValueAndHolder valueandholder = (ValueAndHolder)p_311927_.getValue();
                Holder.Reference reference = valueandholder.holder().orElseGet(() -> Holder.Reference.createStandAlone(p_326796_.cast(), (ResourceKey)p_311927_.getKey()));
                reference.bindValue(valueandholder.value().value());
                return reference;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, p_326796_.cast(), map);
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable
        Supplier<T> supplier;

        protected LazyHolder(HolderOwner<T> p_312861_, @Nullable ResourceKey<T> p_312263_) {
            super(Holder.Reference.Type.STAND_ALONE, p_312861_, p_312263_, null);
        }

        @Override
        protected void bindValue(T p_312469_) {
            super.bindValue(p_312469_);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> p_256629_) {
            super(p_256629_);
        }

        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> p_256303_) {
            return Optional.of(this.getOrCreate(p_256303_));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> p_256298_) {
            return this.holders.computeIfAbsent(p_256298_, p_256154_ -> Holder.Reference.createStandAlone(this.owner, p_256154_));
        }
    }

    record RegisteredValue<T>(T value, Lifecycle lifecycle) {
    }

    static abstract class EmptyTagRegistryLookup<T>
    extends EmptyTagLookup<T>
    implements HolderLookup.RegistryLookup<T> {
        protected EmptyTagRegistryLookup(HolderOwner<T> p_326933_) {
            super(p_326933_);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static class EmptyTagLookupWrapper<T>
    extends EmptyTagRegistryLookup<T>
    implements HolderLookup.RegistryLookup.Delegate<T> {
        private final HolderLookup.RegistryLookup<T> parent;

        EmptyTagLookupWrapper(HolderOwner<T> p_326948_, HolderLookup.RegistryLookup<T> p_326784_) {
            super(p_326948_);
            this.parent = p_326784_;
        }

        @Override
        public HolderLookup.RegistryLookup<T> parent() {
            return this.parent;
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> p_256166_) {
            this.owner = p_256166_;
        }

        public Optional<HolderSet.Named<T>> get(TagKey<T> p_256664_) {
            return Optional.of(HolderSet.emptyNamed(this.owner, p_256664_));
        }
    }
}

