const { chromium } = require('playwright');

const url = process.argv[2];
const delay = parseInt(process.argv[3] || '5000');

if (!url) {
  console.error('Usage: node printPageArgs.js <url> [wait_ms]');
  process.exit(1);
}

(async () => {
  const browser = await chromium.launch();
  const page = await browser.newPage();

  await page.goto(url);
  await page.waitForTimeout(delay);

  const content = await page.content();
  console.log(content);

  await browser.close();
})();
